# 安装 Sii 工具链

Sii 是一门现代编程语言，可以将源代码编译为 JavaScript、WebAssembly 和原生可执行文件。本安装包包含 Sii 编译器和运行时服务器，为 Sii 程序开发提供完整的工具链。

## 系统要求

### macOS

- macOS 12.0 或更高版本
- 架构：arm64（Apple Silicon）或 x86_64（Intel）

### Linux

- glibc 2.17 或更高版本
- 架构：x86_64 或 aarch64

### Windows

- Windows 10 或更高版本
- 架构：x86_64

## 快速安装（推荐）

### macOS / Linux

1. **解压安装包**：
```bash
tar -xzf Sii-2.0.0-<platform>.tar.gz
```

2. **配置系统环境变量**：

   将 `bin` 目录添加到系统的 PATH 环境变量中。编辑 shell 配置文件（`~/.bashrc`、`~/.zshrc` 或 `~/.profile`），添加以下内容：
   ```bash
   export PATH="/path/to/Sii-2.0.0-<platform>/bin:$PATH"
   ```
   
   例如，如果安装到 `/opt/Sii-2.0.0-macos-arm64`：
   ```bash
   export PATH="/opt/Sii-2.0.0-macos-arm64/bin:$PATH"
   ```
   
   然后重新加载配置：
   ```bash
   source ~/.bashrc  # 或 source ~/.zshrc
   ```
   
   或者重启终端。

3. **验证安装**：
```bash
siic --version
sii-runtime-server --version
```

### Windows

1. **解压安装包**到适当目录（例如 `C:\Sii-2.0.0-windows-x64`）

2. **配置系统环境变量**：

   **方法一：使用自动设置脚本（推荐）**
   
   以管理员身份运行以下脚本之一：
   - **命令提示符（CMD）**：右键点击 `setup.bat`，选择"以管理员身份运行"
   - **PowerShell**：右键点击 `setup.ps1`，选择"以管理员身份运行"
   
   脚本会自动将 `bin` 目录添加到系统 PATH 环境变量。
   
   **方法二：手动设置**
   
   通过系统设置添加环境变量：
   1. 打开"系统属性" → "高级" → "环境变量"
   2. 在"系统变量"中找到 `Path`，点击"编辑"
   3. 点击"新建"，添加 `C:\Sii-2.0.0-windows-x64\bin`（根据实际安装路径调整）
   4. 点击"确定"保存
   5. 重新打开命令提示符或 PowerShell 使更改生效
   
   **临时设置（仅当前会话有效）**：
   
   在 PowerShell 中：
   ```powershell
   $env:PATH = "C:\Sii-2.0.0-windows-x64\bin;$env:PATH"
   ```
   
   在命令提示符中：
   ```cmd
   set PATH=C:\Sii-2.0.0-windows-x64\bin;%PATH%
   ```

3. **验证安装**：
```bash
siic --version
sii-runtime-server --version
```

## 原生编译配置

要将 Sii 代码编译为原生可执行文件，只需要一个前置要求：

### 前置要求

**LLVM 工具**：`llc` 和 `clang` 必须在 PATH 中
- macOS：安装 Xcode Command Line Tools：`xcode-select --install`
- Linux：通过包管理器安装：`apt-get install llvm clang` 或 `yum install llvm clang`
- Windows：从 https://llvm.org/builds/ 下载安装

**注意**：本安装包已包含预编译的运行时库静态库（位于 `lib/` 目录），无需安装 Rust 工具链，也无需下载源码。编译器会自动使用打包的运行时库。

## 使用说明

### 编译器 (siic)

```bash
# 编译为 JavaScript
siic compile example.sii

# 编译为原生可执行文件
siic compile --target native example.sii

# 启动开发服务器（支持热重载）
siic serve
```

### 运行时服务器 (sii-runtime-server)

```bash
# 在默认端口（3000）启动服务器
sii-runtime-server
```

## 卸载与更新

### macOS / Linux

1. 从 shell 配置文件中移除 PATH 条目（`~/.bashrc`、`~/.zshrc` 或 `~/.profile`）
2. 删除安装目录：
   ```bash
   rm -rf /path/to/Sii-2.0.0-<platform>
   ```
3. 重新加载 shell 配置或重启终端

### Windows

1. 从系统环境变量中移除 PATH 条目（"系统属性" → "高级" → "环境变量" → "Path"）
2. 删除安装目录
3. 重新打开命令提示符或 PowerShell

### 更新

若需要更新 Sii 工具链，需要先卸载当前版本，然后按上述指导重新安装最新版本的 Sii 工具链。

## 故障排除

### 安装后提示 "command not found"

- **macOS/Linux**：确保已将 `bin` 目录添加到 PATH 环境变量，并重新加载 shell 配置或重启终端
- **Windows**：确保已将 `bin` 目录添加到系统 PATH 环境变量，并重新打开命令提示符或 PowerShell

### 原生编译失败："Runtime static library not found"

**原因**：编译器无法找到运行时库静态库文件。

**解决方法**：
1. 确认安装包中的 `lib/` 目录包含运行时库文件
2. 如果文件缺失，请重新下载安装包
3. 确保已将 `bin` 目录添加到 PATH 环境变量

### 原生编译失败："llc: command not found"

安装 LLVM 工具：
- macOS：`xcode-select --install`
- Linux：`apt-get install llvm` 或 `yum install llvm`
- Windows：从 https://llvm.org/builds/ 下载

