@echo off
REM Sii Language Toolchain Setup Script for Windows
REM This script adds the bin directory to the system PATH environment variable

setlocal EnableDelayedExpansion

REM Get the directory where this script is located
set "SII_HOME=%~dp0"
set "SII_HOME=%SII_HOME:~0,-1%"
set "BIN_PATH=%SII_HOME%\bin"

echo.
echo ========================================
echo Sii Language Toolchain Setup
echo ========================================
echo.
echo Installation directory: %SII_HOME%
echo Bin directory: %BIN_PATH%
echo.

REM Check if running as administrator
net session >nul 2>&1
if %errorLevel% neq 0 (
    echo ERROR: This script must be run as Administrator!
    echo.
    echo Please right-click on this file and select "Run as administrator"
    echo.
    pause
    exit /b 1
)

REM Check if PATH already contains the bin directory
echo %PATH% | findstr /C:"%BIN_PATH%" >nul
if %errorLevel% equ 0 (
    echo The bin directory is already in PATH.
    echo.
    pause
    exit /b 0
)

REM Add to system PATH
echo Adding bin directory to system PATH...
setx PATH "%PATH%;%BIN_PATH%" /M >nul 2>&1
if %errorLevel% neq 0 (
    echo ERROR: Failed to add to system PATH.
    echo Please add %BIN_PATH% to PATH manually.
    echo.
    pause
    exit /b 1
)

echo.
echo Successfully added %BIN_PATH% to system PATH!
echo.
echo IMPORTANT: Please close and reopen your command prompt or PowerShell
echo            for the changes to take effect.
echo.
pause
